/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator;

import com.google.common.io.Files;
import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomizationProperties;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiBase;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationButton;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationHelper;
import de.keksuccino.fancymenu.menu.fancy.helper.DynamicValueInputPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.WindowSizePopup;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.BackgroundOptionsPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.ChooseFilePopup;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.LayoutElement;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.button.LayoutButton;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.button.LayoutButtonDummyCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.button.LayoutVanillaButton;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.FMContextMenu;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.MenuBar;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMTextInputPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMYesNoPopup;
import de.keksuccino.fancymenu.menu.fancy.item.ShapeCustomizationItem;
import de.keksuccino.fancymenu.menu.slideshow.SlideshowHandler;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedImageButton;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import de.keksuccino.konkrete.sound.SoundHandler;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class LayoutEditorUI
extends UIBase {
    public MenuBar bar;
    public LayoutEditorScreen parent;
    protected int tick = 0;
    protected static final ResourceLocation CLOSE_BUTTON_TEXTURE = new ResourceLocation("keksuccino", "close_btn.png");

    public LayoutEditorUI(LayoutEditorScreen parent) {
        this.parent = parent;
        this.updateUI();
    }

    public void updateUI() {
        try {
            boolean extended = true;
            if (this.bar != null) {
                extended = this.bar.isExtended();
            }
            this.bar = new MenuBar();
            this.bar.setExtended(extended);
            FMContextMenu layoutMenu = new FMContextMenu();
            layoutMenu.setAutoclose(true);
            this.bar.addChild(layoutMenu, "fm.editor.ui.tab.layout", MenuBar.ElementAlignment.LEFT);
            AdvancedButton newLayoutButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.layout.new", (String[])new String[0]), true, press -> this.displayUnsavedWarning(call -> {
                if (call.booleanValue()) {
                    MenuCustomization.stopSounds();
                    MenuCustomization.resetSounds();
                    Minecraft.func_71410_x().func_147108_a((Screen)new LayoutEditorScreen(this.parent.screen));
                }
            }));
            layoutMenu.addContent(newLayoutButton);
            OpenLayoutContextMenu openLayoutMenu = new OpenLayoutContextMenu(this);
            openLayoutMenu.setAutoclose(true);
            layoutMenu.addChild(openLayoutMenu);
            AdvancedButton openLayoutButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.layout.open", (String[])new String[0]), true, press -> {
                openLayoutMenu.setParentButton((AdvancedButton)press);
                openLayoutMenu.openMenuAt(0, press.field_230691_m_);
            });
            layoutMenu.addContent(openLayoutButton);
            AdvancedButton layoutSaveButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.layout.save", (String[])new String[0]), true, press -> this.parent.saveLayout());
            layoutMenu.addContent(layoutSaveButton);
            AdvancedButton layoutSaveAsButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.layout.saveas", (String[])new String[0]), true, press -> this.parent.saveLayoutAs());
            layoutMenu.addContent(layoutSaveAsButton);
            LayoutPropertiesContextMenu layoutPropertiesMenu = new LayoutPropertiesContextMenu(this.parent, false);
            layoutPropertiesMenu.setAutoclose(true);
            layoutMenu.addChild(layoutPropertiesMenu);
            AdvancedButton layoutPropertiesButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.layout.properties", (String[])new String[0]), true, press -> {
                layoutPropertiesMenu.setParentButton((AdvancedButton)press);
                layoutPropertiesMenu.openMenuAt(0, press.field_230691_m_);
            });
            layoutMenu.addContent(layoutPropertiesButton);
            AdvancedButton exitButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.exit", (String[])new String[0]), true, press -> this.closeEditor());
            layoutMenu.addContent(exitButton);
            CustomizationButton layoutTab = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.layout", (String[])new String[0]), true, press -> {
                layoutMenu.setParentButton((AdvancedButton)press);
                layoutMenu.openMenuAt(press.field_230690_l_, press.field_230691_m_ + press.func_238483_d_());
            });
            this.bar.addElement(layoutTab, "fm.editor.ui.tab.layout", MenuBar.ElementAlignment.LEFT, false);
            FMContextMenu editMenu = new FMContextMenu();
            editMenu.setAutoclose(true);
            this.bar.addChild(editMenu, "fm.editor.ui.tab.edit", MenuBar.ElementAlignment.LEFT);
            AdvancedButton undoButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.edit.undo", (String[])new String[0]), true, press -> {
                this.parent.history.stepBack();
                try {
                    ((LayoutEditorScreen)Minecraft.func_71410_x().field_71462_r).ui.bar.getChild("fm.editor.ui.tab.edit").openMenuAt(editMenu.getX(), editMenu.getY());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            editMenu.addContent(undoButton);
            AdvancedButton redoButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.edit.redo", (String[])new String[0]), true, press -> {
                this.parent.history.stepForward();
                try {
                    ((LayoutEditorScreen)Minecraft.func_71410_x().field_71462_r).ui.bar.getChild("fm.editor.ui.tab.edit").openMenuAt(editMenu.getX(), editMenu.getY());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            editMenu.addContent(redoButton);
            editMenu.addSeparator();
            AdvancedButton copyButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.edit.copy", (String[])new String[0]), true, press -> this.parent.copySelectedElements());
            editMenu.addContent(copyButton);
            AdvancedButton pasteButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.edit.paste", (String[])new String[0]), true, press -> this.parent.pasteElements());
            editMenu.addContent(pasteButton);
            CustomizationButton editTab = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.edit", (String[])new String[0]), true, press -> {
                editMenu.setParentButton((AdvancedButton)press);
                editMenu.openMenuAt(press.field_230690_l_, press.field_230691_m_ + press.func_238483_d_());
            });
            this.bar.addElement(editTab, "fm.editor.ui.tab.edit", MenuBar.ElementAlignment.LEFT, false);
            FMContextMenu elementMenu = new FMContextMenu();
            elementMenu.setAutoclose(true);
            this.bar.addChild(elementMenu, "fm.editor.ui.tab.element", MenuBar.ElementAlignment.LEFT);
            NewElementContextMenu newElementMenu = new NewElementContextMenu(this.parent);
            newElementMenu.setAutoclose(true);
            elementMenu.addChild(newElementMenu);
            AdvancedButton newElementButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.element.new", (String[])new String[0]), true, press -> {
                newElementMenu.setParentButton((AdvancedButton)press);
                newElementMenu.openMenuAt(0, press.field_230691_m_);
            });
            elementMenu.addContent(newElementButton);
            ManageAudioContextMenu manageAudioMenu = new ManageAudioContextMenu(this.parent);
            manageAudioMenu.setAutoclose(true);
            elementMenu.addChild(manageAudioMenu);
            AdvancedButton manageAudioButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.element.manageaudio", (String[])new String[0]), true, press -> {
                manageAudioMenu.setParentButton((AdvancedButton)press);
                manageAudioMenu.openMenuAt(0, press.field_230691_m_);
            });
            elementMenu.addContent(manageAudioButton);
            HiddenVanillaButtonContextMenu hiddenVanillaMenu = new HiddenVanillaButtonContextMenu(this.parent);
            hiddenVanillaMenu.setAutoclose(true);
            elementMenu.addChild(hiddenVanillaMenu);
            AdvancedButton hiddenVanillaButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.element.deletedvanillabuttons", (String[])new String[0]), true, press -> {
                hiddenVanillaMenu.setParentButton((AdvancedButton)press);
                hiddenVanillaMenu.openMenuAt(0, press.field_230691_m_);
            });
            elementMenu.addContent(hiddenVanillaButton);
            CustomizationButton elementTab = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"helper.editor.ui.element", (String[])new String[0]), true, press -> {
                elementMenu.setParentButton((AdvancedButton)press);
                elementMenu.openMenuAt(press.field_230690_l_, press.field_230691_m_ + press.func_238483_d_());
            });
            this.bar.addElement(elementTab, "fm.editor.ui.tab.element", MenuBar.ElementAlignment.LEFT, false);
            AdvancedImageButton exitEditorButtonTab = new AdvancedImageButton(20, 20, 0, 0, CLOSE_BUTTON_TEXTURE, true, press -> this.closeEditor()){

                public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
                    this.field_230688_j_ = this.field_230689_k_;
                    super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
                }
            };
            exitEditorButtonTab.ignoreLeftMouseDownClickBlock = true;
            exitEditorButtonTab.ignoreBlockedInput = true;
            exitEditorButtonTab.enableRightclick = true;
            exitEditorButtonTab.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.editor.ui.exit.desc", (String[])new String[0]), (String)"%n%"));
            this.bar.addElement((AdvancedButton)exitEditorButtonTab, "fm.editor.ui.tab.exit", MenuBar.ElementAlignment.RIGHT, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void render(MatrixStack matrix, Screen screen) {
        try {
            if (this.bar != null && !PopupHandler.isPopupActive() && screen instanceof LayoutEditorScreen) {
                this.bar.render(matrix, screen);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void displayUnsavedWarning(Consumer<Boolean> callback) {
        PopupHandler.displayPopup((Popup)new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, callback, Locals.localize((String)"helper.editor.ui.unsavedwarning", (String[])new String[0])));
    }

    public void closeEditor() {
        this.displayUnsavedWarning(call -> {
            if (call.booleanValue()) {
                LayoutEditorScreen.isActive = false;
                for (IAnimationRenderer r : AnimationHandler.getAnimations()) {
                    if (!(r instanceof AdvancedAnimation)) continue;
                    ((AdvancedAnimation)r).stopAudio();
                    if (!((AdvancedAnimation)r).replayIntro()) continue;
                    ((AdvancedAnimation)r).resetAnimation();
                }
                MenuCustomization.stopSounds();
                MenuCustomization.resetSounds();
                MenuCustomizationProperties.loadProperties();
                Minecraft.func_71410_x().func_228018_at_().func_216525_a((double)Minecraft.func_71410_x().func_228018_at_().func_216521_a(Minecraft.func_71410_x().field_71474_y.field_74335_Z, Minecraft.func_71410_x().func_211821_e()));
                this.parent.field_230709_l_ = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
                this.parent.field_230708_k_ = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
                Minecraft.func_71410_x().func_147108_a(this.parent.screen);
            }
        });
    }

    public static class HiddenVanillaButtonContextMenu
    extends FMContextMenu {
        private LayoutEditorScreen parent;

        public HiddenVanillaButtonContextMenu(LayoutEditorScreen parent) {
            this.parent = parent;
        }

        @Override
        public void openMenuAt(int x, int y, int screenWidth, int screenHeight) {
            this.content.clear();
            this.separators.clear();
            if (this.parent.hidden.isEmpty()) {
                AdvancedButton emptyButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.empty", (String[])new String[0]), true, press -> {});
                this.addContent(emptyButton);
            } else {
                for (LayoutVanillaButton b : this.parent.hidden) {
                    String name = b.button.getButton().func_230458_i_().getString();
                    AdvancedButton hiddenButton = new AdvancedButton(0, 0, 0, 0, name, true, press -> {
                        this.parent.showVanillaButton(b);
                        this.closeMenu();
                    });
                    hiddenButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.editor.ui.element.deletedvanillabuttons.entry.desc", (String[])new String[0]), (String)"%n%"));
                    this.addContent(hiddenButton);
                }
            }
            super.openMenuAt(x, y, screenWidth, screenHeight);
        }
    }

    public static class MultiselectContextMenu
    extends FMContextMenu {
        private LayoutEditorScreen parent;

        public MultiselectContextMenu(LayoutEditorScreen parent) {
            this.parent = parent;
        }

        @Override
        public void openMenuAt(int x, int y, int screenWidth, int screenHeight) {
            this.content.clear();
            if (this.parent.isObjectFocused()) {
                this.parent.focusedObjectsCache = this.parent.getFocusedObjects();
                this.parent.multiselectStretchedX = false;
                this.parent.multiselectStretchedY = false;
                AdvancedButton deleteBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.multiselect.object.deleteall", (String[])new String[0]), true, press -> this.parent.deleteFocusedObjects());
                deleteBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.multiselect.object.deleteall.btndesc", (String[])new String[0]), (String)"%n%"));
                this.addContent(deleteBtn);
                FMContextMenu stretchMenu = new FMContextMenu();
                stretchMenu.setAutoclose(true);
                this.addChild(stretchMenu);
                AdvancedButton stretchXBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.object.stretch.x", (String[])new String[0]), true, press -> {
                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                    for (LayoutElement o : this.parent.focusedObjectsCache) {
                        if (!o.isStretchable()) continue;
                        o.setStretchedX(!this.parent.multiselectStretchedX, false);
                    }
                    boolean bl = this.parent.multiselectStretchedX = !this.parent.multiselectStretchedX;
                    if (!this.parent.multiselectStretchedX) {
                        press.func_238482_a_((ITextComponent)new StringTextComponent(Locals.localize((String)"helper.creator.object.stretch.x", (String[])new String[0])));
                    } else {
                        press.func_238482_a_((ITextComponent)new StringTextComponent("\u00a7a" + Locals.localize((String)"helper.creator.object.stretch.x", (String[])new String[0])));
                    }
                });
                stretchMenu.addContent(stretchXBtn);
                AdvancedButton stretchYBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.object.stretch.y", (String[])new String[0]), true, press -> {
                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                    for (LayoutElement o : this.parent.focusedObjectsCache) {
                        if (!o.isStretchable()) continue;
                        o.setStretchedY(!this.parent.multiselectStretchedY, false);
                    }
                    boolean bl = this.parent.multiselectStretchedY = !this.parent.multiselectStretchedY;
                    if (!this.parent.multiselectStretchedY) {
                        press.func_238482_a_((ITextComponent)new StringTextComponent(Locals.localize((String)"helper.creator.object.stretch.y", (String[])new String[0])));
                    } else {
                        press.func_238482_a_((ITextComponent)new StringTextComponent("\u00a7a" + Locals.localize((String)"helper.creator.object.stretch.y", (String[])new String[0])));
                    }
                });
                stretchMenu.addContent(stretchYBtn);
                AdvancedButton stretchBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.multiselect.object.stretchall", (String[])new String[0]), true, press -> {
                    stretchMenu.setParentButton((AdvancedButton)press);
                    stretchMenu.openMenuAt(0, press.field_230691_m_, screenWidth, screenHeight);
                });
                stretchBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.multiselect.object.stretchall.btndesc", (String[])new String[0]), (String)"%n%"));
                this.addContent(stretchBtn);
                AdvancedButton copyButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.editor.ui.edit.copy", (String[])new String[0]), press -> this.parent.copySelectedElements());
                this.addContent(copyButton);
                AdvancedButton pasteButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.editor.ui.edit.paste", (String[])new String[0]), press -> this.parent.pasteElements());
                this.addContent(pasteButton);
                boolean allVanillaBtns = true;
                boolean allBtns = true;
                for (LayoutElement o : this.parent.focusedObjectsCache) {
                    if (!(o instanceof LayoutVanillaButton)) {
                        allVanillaBtns = false;
                    }
                    if (o instanceof LayoutVanillaButton || o instanceof LayoutButton) continue;
                    allBtns = false;
                }
                if (this.parent.focusedObjectsCache.isEmpty()) {
                    allVanillaBtns = false;
                    allBtns = false;
                }
                if (allVanillaBtns) {
                    AdvancedButton resetOriBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.multiselect.vanillabutton.resetorientation", (String[])new String[0]), true, press -> {
                        this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        for (LayoutElement o : this.parent.focusedObjectsCache) {
                            if (!(o instanceof LayoutVanillaButton)) continue;
                            LayoutVanillaButton vb = (LayoutVanillaButton)o;
                            vb.object.orientation = "original";
                            vb.object.posX = vb.button.x;
                            vb.object.posY = vb.button.y;
                            vb.object.width = vb.button.width;
                            vb.object.height = vb.button.height;
                        }
                        this.closeMenu();
                        Minecraft.func_71410_x().func_147108_a((Screen)this.parent);
                    });
                    resetOriBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.multiselect.vanillabutton.resetorientation.btndesc", (String[])new String[0]), (String)"%n%"));
                    this.addContent(resetOriBtn);
                    AdvancedButton hideAllBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.multiselect.vanillabutton.hideall", (String[])new String[0]), true, press -> {
                        this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        this.parent.history.setPreventSnapshotSaving(true);
                        for (LayoutElement o : this.parent.focusedObjectsCache) {
                            if (!(o instanceof LayoutVanillaButton)) continue;
                            LayoutVanillaButton vb = (LayoutVanillaButton)o;
                            this.parent.hideVanillaButton(vb);
                        }
                        this.parent.focusedObjects.clear();
                        this.parent.focusedObjectsCache.clear();
                        this.parent.multiselectRightclickMenu.closeMenu();
                        this.parent.history.setPreventSnapshotSaving(false);
                    });
                    hideAllBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.multiselect.vanillabutton.hideall.btndesc", (String[])new String[0]), (String)"%n%"));
                    this.addContent(hideAllBtn);
                }
                if (allBtns) {
                    FMContextMenu textureMenu = new FMContextMenu();
                    textureMenu.setAutoclose(true);
                    this.addChild(textureMenu);
                    AdvancedButton normalTextureBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.custombutton.config.texture.normal", (String[])new String[0]), true, press -> this.parent.setButtonTexturesForFocusedObjects(false));
                    textureMenu.addContent(normalTextureBtn);
                    AdvancedButton hoverTextureBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.custombutton.config.texture.hovered", (String[])new String[0]), true, press -> this.parent.setButtonTexturesForFocusedObjects(true));
                    textureMenu.addContent(hoverTextureBtn);
                    AdvancedButton resetTextureBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.custombutton.config.texture.reset", (String[])new String[0]), true, press -> {
                        this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        this.parent.history.setPreventSnapshotSaving(true);
                        for (LayoutElement o : this.parent.focusedObjectsCache) {
                            if (o instanceof LayoutVanillaButton) {
                                LayoutVanillaButton vb = (LayoutVanillaButton)o;
                                vb.backHovered = null;
                                vb.backNormal = null;
                                ((LayoutButtonDummyCustomizationItem)o.object).setTexture(null);
                                this.parent.setVanillaTexture(vb, null, null);
                                continue;
                            }
                            if (!(o instanceof LayoutButton)) continue;
                            LayoutButton lb = (LayoutButton)o;
                            lb.backHovered = null;
                            lb.backNormal = null;
                            ((LayoutButtonDummyCustomizationItem)o.object).setTexture(null);
                        }
                        this.parent.history.setPreventSnapshotSaving(false);
                    });
                    resetTextureBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.multiselect.button.buttontexture.reset.btndesc", (String[])new String[0]), (String)"%n%"));
                    textureMenu.addContent(resetTextureBtn);
                    AdvancedButton buttonTextureBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.custombutton.config.texture", (String[])new String[0]), true, press -> {
                        textureMenu.setParentButton((AdvancedButton)press);
                        textureMenu.openMenuAt(0, press.field_230691_m_, screenWidth, screenHeight);
                    });
                    buttonTextureBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.multiselect.button.buttontexture.btndesc", (String[])new String[0]), (String)"%n%"));
                    this.addContent(buttonTextureBtn);
                    AdvancedButton clickSoundBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.items.button.clicksound", (String[])new String[0]), true, press -> {
                        ChooseFilePopup cf = new ChooseFilePopup(call -> {
                            if (call != null) {
                                File f = new File((String)call);
                                if (f.exists() && f.isFile() && f.getName().endsWith(".wav")) {
                                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                                    this.parent.history.setPreventSnapshotSaving(true);
                                    for (LayoutElement o : this.parent.focusedObjectsCache) {
                                        if (o instanceof LayoutVanillaButton) {
                                            LayoutVanillaButton vb = (LayoutVanillaButton)o;
                                            vb.clicksound = call;
                                            this.parent.setVanillaClickSound(vb, (String)call);
                                            continue;
                                        }
                                        if (!(o instanceof LayoutButton)) continue;
                                        LayoutButton lb = (LayoutButton)o;
                                        lb.clicksound = call;
                                    }
                                    this.parent.history.setPreventSnapshotSaving(false);
                                } else {
                                    LayoutEditorScreen.displayNotification("\u00a7c\u00a7l" + Locals.localize((String)"helper.creator.invalidaudio.title", (String[])new String[0]), "", Locals.localize((String)"helper.creator.invalidaudio.desc", (String[])new String[0]), "", "", "", "", "", "");
                                }
                            }
                        }, "wav");
                        PopupHandler.displayPopup((Popup)cf);
                    });
                    clickSoundBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.multiselect.button.clicksound.btndesc", (String[])new String[0]), (String)"%n%"));
                    this.addContent(clickSoundBtn);
                    AdvancedButton resetClickSoundBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.items.button.clicksound.reset", (String[])new String[0]), true, press -> {
                        this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        this.parent.history.setPreventSnapshotSaving(true);
                        for (LayoutElement o : this.parent.focusedObjectsCache) {
                            if (o instanceof LayoutVanillaButton) {
                                LayoutVanillaButton vb = (LayoutVanillaButton)o;
                                vb.clicksound = null;
                                this.parent.setVanillaClickSound(vb, null);
                                continue;
                            }
                            if (!(o instanceof LayoutButton)) continue;
                            LayoutButton lb = (LayoutButton)o;
                            lb.clicksound = null;
                        }
                        this.parent.history.setPreventSnapshotSaving(false);
                    });
                    resetClickSoundBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.multiselect.button.clicksound.reset.btndesc", (String[])new String[0]), (String)"%n%"));
                    this.addContent(resetClickSoundBtn);
                    AdvancedButton hoverSoundBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.items.button.hoversound", (String[])new String[0]), true, press -> {
                        ChooseFilePopup cf = new ChooseFilePopup(call -> {
                            if (call != null) {
                                File f = new File((String)call);
                                if (f.exists() && f.isFile() && f.getName().endsWith(".wav")) {
                                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                                    this.parent.history.setPreventSnapshotSaving(true);
                                    for (LayoutElement o : this.parent.focusedObjectsCache) {
                                        if (o instanceof LayoutVanillaButton) {
                                            LayoutVanillaButton vb = (LayoutVanillaButton)o;
                                            vb.hoverSound = call;
                                            this.parent.setVanillaHoverSound(vb, (String)call);
                                            continue;
                                        }
                                        if (!(o instanceof LayoutButton)) continue;
                                        LayoutButton lb = (LayoutButton)o;
                                        lb.hoverSound = call;
                                    }
                                    this.parent.history.setPreventSnapshotSaving(false);
                                } else {
                                    LayoutEditorScreen.displayNotification("\u00a7c\u00a7l" + Locals.localize((String)"helper.creator.invalidaudio.title", (String[])new String[0]), "", Locals.localize((String)"helper.creator.invalidaudio.desc", (String[])new String[0]), "", "", "", "", "", "");
                                }
                            }
                        }, "wav");
                        PopupHandler.displayPopup((Popup)cf);
                    });
                    hoverSoundBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.multiselect.button.hoversound.btndesc", (String[])new String[0]), (String)"%n%"));
                    this.addContent(hoverSoundBtn);
                    AdvancedButton resetHoverSoundBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.items.button.hoversound.reset", (String[])new String[0]), true, press -> {
                        this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        this.parent.history.setPreventSnapshotSaving(true);
                        for (LayoutElement o : this.parent.focusedObjectsCache) {
                            if (o instanceof LayoutVanillaButton) {
                                LayoutVanillaButton vb = (LayoutVanillaButton)o;
                                vb.hoverSound = null;
                                this.parent.setVanillaHoverSound(vb, null);
                                continue;
                            }
                            if (!(o instanceof LayoutButton)) continue;
                            LayoutButton lb = (LayoutButton)o;
                            lb.hoverSound = null;
                        }
                        this.parent.history.setPreventSnapshotSaving(false);
                    });
                    resetHoverSoundBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.multiselect.button.hoversound.reset.btndesc", (String[])new String[0]), (String)"%n%"));
                    this.addContent(resetHoverSoundBtn);
                }
            }
            super.openMenuAt(x, y, screenWidth, screenHeight);
        }
    }

    public static class ManageAudioContextMenu
    extends FMContextMenu {
        private LayoutEditorScreen parent;

        public ManageAudioContextMenu(LayoutEditorScreen parent) {
            this.parent = parent;
        }

        @Override
        public void openMenuAt(int x, int y, int screenWidth, int screenHeight) {
            this.content.clear();
            if (this.parent.audio.isEmpty()) {
                AdvancedButton bt = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.empty", (String[])new String[0]), true, press -> {});
                this.addContent(bt);
            } else {
                for (Map.Entry<String, Boolean> m : this.parent.audio.entrySet()) {
                    String label = new File(m.getKey()).getName();
                    if (Minecraft.func_71410_x().field_71466_p.func_78256_a(label) > 200) {
                        label = Minecraft.func_71410_x().field_71466_p.func_238412_a_(label, 200) + "..";
                    }
                    FMContextMenu actionsMenu = new FMContextMenu();
                    actionsMenu.setAutoclose(true);
                    this.addChild(actionsMenu);
                    AdvancedButton deleteButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.audio.delete", (String[])new String[0]), true, press2 -> {
                        this.closeMenu();
                        PopupHandler.displayPopup((Popup)new FMYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                            if (call.booleanValue()) {
                                this.parent.audio.remove(m.getKey());
                                SoundHandler.stopSound((String)((String)m.getKey()));
                                MenuCustomization.unregisterSound((String)m.getKey());
                            }
                        }, "\u00a7c\u00a7l" + Locals.localize((String)"helper.creator.messages.sure", (String[])new String[0]), "", "", Locals.localize((String)"helper.creator.audio.delete.msg", (String[])new String[0]), "", ""));
                    });
                    actionsMenu.addContent(deleteButton);
                    String lab = Locals.localize((String)"helper.editor.ui.element.manageaudio.loop.off", (String[])new String[0]);
                    if (m.getValue().booleanValue()) {
                        lab = Locals.localize((String)"helper.editor.ui.element.manageaudio.loop.on", (String[])new String[0]);
                    }
                    AdvancedButton toggleLoopButton = new AdvancedButton(0, 0, 0, 16, lab, true, press2 -> {
                        if (((AdvancedButton)press2).func_230458_i_().getString().equals(Locals.localize((String)"helper.editor.ui.element.manageaudio.loop.off", (String[])new String[0]))) {
                            SoundHandler.setLooped((String)((String)m.getKey()), (boolean)true);
                            this.parent.audio.put((String)m.getKey(), true);
                            ((AdvancedButton)press2).setMessage(Locals.localize((String)"helper.editor.ui.element.manageaudio.loop.on", (String[])new String[0]));
                        } else {
                            SoundHandler.setLooped((String)((String)m.getKey()), (boolean)false);
                            this.parent.audio.put((String)m.getKey(), false);
                            ((AdvancedButton)press2).setMessage(Locals.localize((String)"helper.editor.ui.element.manageaudio.loop.off", (String[])new String[0]));
                        }
                    });
                    actionsMenu.addContent(toggleLoopButton);
                    AdvancedButton actionsButton = new AdvancedButton(0, 0, 0, 16, label, true, press -> {
                        actionsMenu.setParentButton((AdvancedButton)press);
                        actionsMenu.openMenuAt(0, press.field_230691_m_, screenWidth, screenHeight);
                    });
                    this.addContent(actionsButton);
                }
            }
            super.openMenuAt(x, y, screenWidth, screenHeight);
        }
    }

    public static class NewElementContextMenu
    extends FMContextMenu {
        private LayoutEditorScreen parent;

        public NewElementContextMenu(LayoutEditorScreen parent) {
            this.parent = parent;
        }

        @Override
        public void openMenuAt(int x, int y, int screenWidth, int screenHeight) {
            this.content.clear();
            AdvancedButton imageButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"helper.creator.add.image", (String[])new String[0]), press -> PopupHandler.displayPopup((Popup)new ChooseFilePopup(this.parent::addTexture, "jpg", "jpeg", "png", "gif")));
            this.addContent(imageButton);
            AdvancedButton webImageButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"helper.creator.add.webimage", (String[])new String[0]), press -> PopupHandler.displayPopup((Popup)new DynamicValueInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"helper.creator.web.enterurl", (String[])new String[0]), null, 240, this.parent::addWebTexture)));
            this.addContent(webImageButton);
            AdvancedButton textButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"helper.creator.add.text", (String[])new String[0]), press -> PopupHandler.displayPopup((Popup)new DynamicValueInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"helper.creator.add.text.newtext", (String[])new String[0]) + ":", null, 240, this.parent::addText)));
            this.addContent(textButton);
            AdvancedButton webTextButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"helper.creator.add.webtext", (String[])new String[0]), press -> PopupHandler.displayPopup((Popup)new DynamicValueInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"helper.creator.web.enterurl", (String[])new String[0]), null, 240, this.parent::addWebText)));
            this.addContent(webTextButton);
            FMContextMenu splashMenu = new FMContextMenu();
            splashMenu.setAutoclose(true);
            this.addChild(splashMenu);
            AdvancedButton singleSplashButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.add.splash.single", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new DynamicValueInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"helper.creator.add.splash.single.desc", (String[])new String[0]), null, 240, this.parent::addSingleSplashText)));
            singleSplashButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.add.splash.single.desc", (String[])new String[0]), (String)"%n%"));
            splashMenu.addContent(singleSplashButton);
            AdvancedButton multiSplashButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.add.splash.multi", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new ChooseFilePopup(this.parent::addMultiSplashText, "txt")));
            multiSplashButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.add.splash.multi.desc", (String[])new String[0]), (String)"%n%"));
            splashMenu.addContent(multiSplashButton);
            AdvancedButton splashButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"helper.creator.add.splash", (String[])new String[0]), press -> {
                splashMenu.setParentButton((AdvancedButton)press);
                splashMenu.openMenuAt(0, press.field_230691_m_, screenWidth, screenHeight);
            });
            this.addContent(splashButton);
            AdvancedButton buttonButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"helper.creator.add.button", (String[])new String[0]), press -> PopupHandler.displayPopup((Popup)new DynamicValueInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"helper.creator.add.button.label", (String[])new String[0]) + ":", null, 240, this.parent::addButton)));
            this.addContent(buttonButton);
            AdvancedButton audioButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"helper.creator.add.audio", (String[])new String[0]), press -> PopupHandler.displayPopup((Popup)new ChooseFilePopup(this.parent::addAudio, "wav")));
            this.addContent(audioButton);
            AdvancedButton playerEntityButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"helper.creator.add.playerentity", (String[])new String[0]), press -> this.parent.addPlayerEntity());
            this.addContent(playerEntityButton);
            FMContextMenu animationMenu = new FMContextMenu();
            animationMenu.setAutoclose(true);
            this.addChild(animationMenu);
            AdvancedButton inputAnimationButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"helper.creator.add.animation.entername", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new FMTextInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"helper.creator.add.animation.entername.title", (String[])new String[0]) + ":", null, 240, this.parent::addAnimation)));
            animationMenu.addContent(inputAnimationButton);
            animationMenu.addSeparator();
            for (String s : AnimationHandler.getCustomAnimationNames()) {
                AdvancedButton aniB = new AdvancedButton(0, 0, 0, 20, s, true, press -> this.parent.addAnimation(s));
                animationMenu.addContent(aniB);
            }
            AdvancedButton animationButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"helper.creator.add.animation", (String[])new String[0]), press -> {
                animationMenu.setParentButton((AdvancedButton)press);
                animationMenu.openMenuAt(0, press.field_230691_m_, screenWidth, screenHeight);
            });
            this.addContent(animationButton);
            FMContextMenu slideshowMenu = new FMContextMenu();
            slideshowMenu.setAutoclose(true);
            this.addChild(slideshowMenu);
            AdvancedButton inputSlideshowButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"helper.creator.add.slideshow.entername", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new FMTextInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"helper.creator.add.slideshow.entername.title", (String[])new String[0]) + ":", null, 240, this.parent::addSlideshow)));
            slideshowMenu.addContent(inputSlideshowButton);
            slideshowMenu.addSeparator();
            for (String s : SlideshowHandler.getSlideshowNames()) {
                String name = s;
                if (Minecraft.func_71410_x().field_71466_p.func_78256_a(name) > 90) {
                    name = Minecraft.func_71410_x().field_71466_p.func_238412_a_(name, 90) + "..";
                }
                AdvancedButton slideshowB = new AdvancedButton(0, 0, 0, 20, name, true, press -> {
                    if (SlideshowHandler.slideshowExists(s)) {
                        this.parent.addSlideshow(s);
                    }
                });
                slideshowMenu.addContent(slideshowB);
            }
            AdvancedButton slideshowButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"helper.creator.add.slideshow", (String[])new String[0]), press -> {
                slideshowMenu.setParentButton((AdvancedButton)press);
                slideshowMenu.openMenuAt(0, press.field_230691_m_, screenWidth, screenHeight);
            });
            this.addContent(slideshowButton);
            FMContextMenu shapesMenu = new FMContextMenu();
            shapesMenu.setAutoclose(true);
            this.addChild(shapesMenu);
            AdvancedButton addRectangleButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"helper.creator.add.shapes.rectangle", (String[])new String[0]), press -> this.parent.addShape(ShapeCustomizationItem.Shape.RECTANGLE));
            shapesMenu.addContent(addRectangleButton);
            AdvancedButton shapesButton = new AdvancedButton(0, 0, 0, 20, Locals.localize((String)"helper.creator.add.shapes", (String[])new String[0]), press -> {
                shapesMenu.setParentButton((AdvancedButton)press);
                shapesMenu.openMenuAt(0, press.field_230691_m_, screenWidth, screenHeight);
            });
            this.addContent(shapesButton);
            super.openMenuAt(x, y, screenWidth, screenHeight);
        }
    }

    public static class LayoutPropertiesContextMenu
    extends FMContextMenu {
        private LayoutEditorScreen parent;
        private AdvancedButton renderingOrderBackgroundButton;
        private AdvancedButton renderingOrderForegroundButton;
        private boolean isRightclickOpened;

        public LayoutPropertiesContextMenu(LayoutEditorScreen parent, boolean openedByRightclick) {
            this.parent = parent;
            this.isRightclickOpened = openedByRightclick;
        }

        @Override
        public void openMenuAt(int x, int y, int screenWidth, int screenHeight) {
            this.content.clear();
            AdvancedButton backgroundOptionsButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.backgroundoptions", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new BackgroundOptionsPopup(this.parent)));
            this.addContent(backgroundOptionsButton);
            AdvancedButton resetBackgroundButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.layoutoptions.resetbackground", (String[])new String[0]), true, press -> {
                if (this.parent.backgroundTexture != null || this.parent.backgroundAnimation != null || this.parent.backgroundPanorama != null) {
                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                }
                if (this.parent.backgroundAnimation != null) {
                    ((AdvancedAnimation)this.parent.backgroundAnimation).stopAudio();
                }
                this.parent.backgroundAnimationNames = new ArrayList<String>();
                this.parent.backgroundPanorama = null;
                this.parent.backgroundSlideshow = null;
                this.parent.backgroundAnimation = null;
                this.parent.backgroundTexture = null;
            });
            this.addContent(resetBackgroundButton);
            this.addSeparator();
            String randomModeString = Locals.localize((String)"fancymenu.helper.creator.layoutoptions.randommode.on", (String[])new String[0]);
            if (!this.parent.randomMode) {
                randomModeString = Locals.localize((String)"fancymenu.helper.creator.layoutoptions.randommode.off", (String[])new String[0]);
            }
            AdvancedButton randomModeButton = new AdvancedButton(0, 0, 0, 16, randomModeString, true, press -> {
                if (this.parent.randomMode) {
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"fancymenu.helper.creator.layoutoptions.randommode.off", (String[])new String[0]));
                    this.parent.randomMode = false;
                } else {
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"fancymenu.helper.creator.layoutoptions.randommode.on", (String[])new String[0]));
                    this.parent.randomMode = true;
                }
            });
            randomModeButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.creator.layoutoptions.randommode.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(randomModeButton);
            AdvancedButton randomModeGroupButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"fancymenu.helper.creator.layoutoptions.randommode.setgroup", (String[])new String[0]), true, press -> {
                FMTextInputPopup pop = new FMTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"fancymenu.helper.creator.layoutoptions.randommode.setgroup", (String[])new String[0]), CharacterFilter.getIntegerCharacterFiler(), 240, call -> {
                    if (call != null) {
                        if (!MathUtils.isInteger((String)call)) {
                            call = "1";
                        }
                        if (!call.equalsIgnoreCase(this.parent.randomGroup)) {
                            this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        }
                        this.parent.randomGroup = call;
                    }
                });
                if (this.parent.randomGroup != null) {
                    pop.setText(this.parent.randomGroup);
                }
                PopupHandler.displayPopup((Popup)pop);
            }){

                public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                    this.field_230693_o_ = ((LayoutPropertiesContextMenu)this).parent.randomMode;
                    super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                }
            };
            randomModeGroupButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.creator.layoutoptions.randommode.setgroup.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(randomModeGroupButton);
            String randomModeFirstTimeString = Locals.localize((String)"fancymenu.helper.creator.layoutoptions.randommode.onlyfirsttime.on", (String[])new String[0]);
            if (!this.parent.randomOnlyFirstTime) {
                randomModeFirstTimeString = Locals.localize((String)"fancymenu.helper.creator.layoutoptions.randommode.onlyfirsttime.off", (String[])new String[0]);
            }
            AdvancedButton randomModeFirstTimeButton = new AdvancedButton(0, 0, 0, 16, randomModeFirstTimeString, true, press -> {
                if (this.parent.randomOnlyFirstTime) {
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"fancymenu.helper.creator.layoutoptions.randommode.onlyfirsttime.off", (String[])new String[0]));
                    this.parent.randomOnlyFirstTime = false;
                } else {
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"fancymenu.helper.creator.layoutoptions.randommode.onlyfirsttime.on", (String[])new String[0]));
                    this.parent.randomOnlyFirstTime = true;
                }
            }){

                public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                    this.field_230693_o_ = ((LayoutPropertiesContextMenu)this).parent.randomMode;
                    super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                }
            };
            randomModeFirstTimeButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.creator.layoutoptions.randommode.onlyfirsttime.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(randomModeFirstTimeButton);
            this.addSeparator();
            FMContextMenu renderingOrderMenu = new FMContextMenu();
            renderingOrderMenu.setAutoclose(true);
            this.addChild(renderingOrderMenu);
            this.renderingOrderBackgroundButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.layoutoptions.renderorder.background", (String[])new String[0]), true, press -> {
                ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"helper.creator.layoutoptions.renderorder.background", (String[])new String[0]));
                this.renderingOrderForegroundButton.setMessage(Locals.localize((String)"helper.creator.layoutoptions.renderorder.foreground", (String[])new String[0]));
                if (!this.parent.renderorder.equals("background")) {
                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                }
                this.parent.renderorder = "background";
            });
            renderingOrderMenu.addContent(this.renderingOrderBackgroundButton);
            this.renderingOrderForegroundButton = new AdvancedButton(0, 0, 0, 16, "\u00a7a" + Locals.localize((String)"helper.creator.layoutoptions.renderorder.foreground", (String[])new String[0]), true, press -> {
                ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"helper.creator.layoutoptions.renderorder.foreground", (String[])new String[0]));
                this.renderingOrderBackgroundButton.setMessage(Locals.localize((String)"helper.creator.layoutoptions.renderorder.background", (String[])new String[0]));
                if (!this.parent.renderorder.equals("foreground")) {
                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                }
                this.parent.renderorder = "foreground";
            });
            renderingOrderMenu.addContent(this.renderingOrderForegroundButton);
            if (this.parent.renderorder.equals("background")) {
                this.renderingOrderForegroundButton.setMessage(Locals.localize((String)"helper.creator.layoutoptions.renderorder.foreground", (String[])new String[0]));
                this.renderingOrderBackgroundButton.setMessage("\u00a7a" + Locals.localize((String)"helper.creator.layoutoptions.renderorder.background", (String[])new String[0]));
            }
            AdvancedButton renderingOrderButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.layoutoptions.renderorder", (String[])new String[0]), true, press -> {
                renderingOrderMenu.setParentButton((AdvancedButton)press);
                renderingOrderMenu.openMenuAt(0, press.field_230691_m_, screenWidth, screenHeight);
            });
            this.addContent(renderingOrderButton);
            AdvancedButton menuScaleButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.rightclick.scale", (String[])new String[0]), true, press -> {
                FMTextInputPopup p = new FMTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"helper.creator.rightclick.scale", (String[])new String[0]), CharacterFilter.getIntegerCharacterFiler(), 240, call -> {
                    if (call != null && MathUtils.isInteger((String)call)) {
                        int s = Integer.parseInt(call);
                        if (s < 0) {
                            LayoutEditorScreen.displayNotification(Locals.localize((String)"helper.creator.rightclick.scale.invalid", (String[])new String[0]), "", "", "", "");
                        } else {
                            if (this.parent.scale != s) {
                                this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                            }
                            this.parent.scale = s;
                            this.parent.func_231158_b_(Minecraft.func_71410_x(), Minecraft.func_71410_x().func_228018_at_().func_198107_o(), Minecraft.func_71410_x().func_228018_at_().func_198087_p());
                        }
                    }
                });
                p.setText("" + this.parent.scale);
                PopupHandler.displayPopup((Popup)p);
            });
            this.addContent(menuScaleButton);
            FMContextMenu openCloseSoundMenu = new FMContextMenu();
            openCloseSoundMenu.setAutoclose(true);
            this.addChild(openCloseSoundMenu);
            AdvancedButton openSoundBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.openaudio", (String[])new String[0]), true, press -> {
                ChooseFilePopup p = new ChooseFilePopup(call -> {
                    if (call != null) {
                        if (call.length() < 3) {
                            if (this.parent.openAudio != null) {
                                this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                            }
                            this.parent.openAudio = null;
                        } else {
                            File f = new File((String)call);
                            if (f.exists() && f.isFile() && f.getName().toLowerCase().endsWith(".wav")) {
                                if (this.parent.openAudio != call) {
                                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                                }
                                this.parent.openAudio = call;
                            } else {
                                LayoutEditorScreen.displayNotification("\u00a7c\u00a7l" + Locals.localize((String)"helper.creator.invalidaudio.title", (String[])new String[0]), "", Locals.localize((String)"helper.creator.invalidaudio.desc", (String[])new String[0]), "", "", "", "", "");
                            }
                        }
                    } else {
                        if (this.parent.openAudio != null) {
                            this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        }
                        this.parent.openAudio = null;
                    }
                }, "wav");
                if (this.parent.openAudio != null) {
                    p.setText(this.parent.openAudio);
                }
                PopupHandler.displayPopup((Popup)p);
            });
            openSoundBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.openaudio.desc", (String[])new String[0]), (String)"%n%"));
            openCloseSoundMenu.addContent(openSoundBtn);
            AdvancedButton resetOpenBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.openaudio.reset", (String[])new String[0]), true, press -> {
                if (this.parent.openAudio != null) {
                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                }
                this.parent.openAudio = null;
            });
            resetOpenBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.opencloseaudio.reset.desc", (String[])new String[0]), (String)"%n%"));
            openCloseSoundMenu.addContent(resetOpenBtn);
            AdvancedButton closeSoundBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.closeaudio", (String[])new String[0]), true, press -> {
                ChooseFilePopup p = new ChooseFilePopup(call -> {
                    if (call != null) {
                        if (call.length() < 3) {
                            if (this.parent.closeAudio != null) {
                                this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                            }
                            this.parent.closeAudio = null;
                        } else {
                            File f = new File((String)call);
                            if (f.exists() && f.isFile() && f.getName().toLowerCase().endsWith(".wav")) {
                                if (this.parent.closeAudio != call) {
                                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                                }
                                this.parent.closeAudio = call;
                            } else {
                                LayoutEditorScreen.displayNotification("\u00a7c\u00a7l" + Locals.localize((String)"helper.creator.invalidaudio.title", (String[])new String[0]), "", Locals.localize((String)"helper.creator.invalidaudio.desc", (String[])new String[0]), "", "", "", "", "");
                            }
                        }
                    } else {
                        if (this.parent.closeAudio != null) {
                            this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        }
                        this.parent.closeAudio = null;
                    }
                }, "wav");
                if (this.parent.closeAudio != null) {
                    p.setText(this.parent.closeAudio);
                }
                PopupHandler.displayPopup((Popup)p);
            });
            closeSoundBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.closeaudio.desc", (String[])new String[0]), (String)"%n%"));
            openCloseSoundMenu.addContent(closeSoundBtn);
            AdvancedButton resetCloseBtn = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.closeaudio.reset", (String[])new String[0]), true, press -> {
                if (this.parent.closeAudio != null) {
                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                }
                this.parent.closeAudio = null;
            });
            resetCloseBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.opencloseaudio.reset.desc", (String[])new String[0]), (String)"%n%"));
            openCloseSoundMenu.addContent(resetCloseBtn);
            AdvancedButton openCloseSoundButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.opencloseaudio", (String[])new String[0]), true, press -> {
                openCloseSoundMenu.setParentButton((AdvancedButton)press);
                openCloseSoundMenu.openMenuAt(0, press.field_230691_m_, screenWidth, screenHeight);
            });
            openCloseSoundButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.opencloseaudio.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(openCloseSoundButton);
            this.addSeparator();
            FMContextMenu windowSizeMenu = new FMContextMenu();
            windowSizeMenu.setAutoclose(true);
            this.addChild(windowSizeMenu);
            AdvancedButton biggerThanButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.windowsize.biggerthan", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new WindowSizePopup(this.parent, WindowSizePopup.ActionType.BIGGERTHAN)));
            windowSizeMenu.addContent(biggerThanButton);
            AdvancedButton smallerThanButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.windowsize.smallerthan", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new WindowSizePopup(this.parent, WindowSizePopup.ActionType.SMALLERTHAN)));
            windowSizeMenu.addContent(smallerThanButton);
            AdvancedButton windowSizeButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.windowsize", (String[])new String[0]), true, press -> {
                windowSizeMenu.setParentButton((AdvancedButton)press);
                windowSizeMenu.openMenuAt(0, press.field_230691_m_, screenWidth, screenHeight);
            });
            this.addContent(windowSizeButton);
            AdvancedButton requiredModsButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.layoutoptions.requiredmods", (String[])new String[0]), true, press -> {
                FMTextInputPopup p = new FMTextInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"helper.creator.layoutoptions.requiredmods.desc", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (this.parent.requiredmods != call) {
                            this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        }
                        this.parent.requiredmods = call;
                    }
                });
                if (this.parent.requiredmods != null) {
                    p.setText(this.parent.requiredmods);
                }
                PopupHandler.displayPopup((Popup)p);
            });
            this.addContent(requiredModsButton);
            FMContextMenu mcVersionMenu = new FMContextMenu();
            mcVersionMenu.setAutoclose(true);
            this.addChild(mcVersionMenu);
            AdvancedButton minMcVersionButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.layoutoptions.version.minimum", (String[])new String[0]), true, press -> {
                FMTextInputPopup p = new FMTextInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"helper.creator.layoutoptions.version.minimum.mc", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (this.parent.minimumMC != call) {
                            this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        }
                        this.parent.minimumMC = call;
                    }
                });
                if (this.parent.minimumMC != null) {
                    p.setText(this.parent.minimumMC);
                }
                PopupHandler.displayPopup((Popup)p);
            });
            mcVersionMenu.addContent(minMcVersionButton);
            AdvancedButton maxMcVersionButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.layoutoptions.version.maximum", (String[])new String[0]), true, press -> {
                FMTextInputPopup p = new FMTextInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"helper.creator.layoutoptions.version.maximum.mc", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (this.parent.maximumMC != call) {
                            this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        }
                        this.parent.maximumMC = call;
                    }
                });
                if (this.parent.maximumMC != null) {
                    p.setText(this.parent.maximumMC);
                }
                PopupHandler.displayPopup((Popup)p);
            });
            mcVersionMenu.addContent(maxMcVersionButton);
            AdvancedButton mcVersionButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.layoutoptions.version.mc", (String[])new String[0]), true, press -> {
                mcVersionMenu.setParentButton((AdvancedButton)press);
                mcVersionMenu.openMenuAt(0, press.field_230691_m_, screenWidth, screenHeight);
            });
            this.addContent(mcVersionButton);
            FMContextMenu fmVersionMenu = new FMContextMenu();
            fmVersionMenu.setAutoclose(true);
            this.addChild(fmVersionMenu);
            AdvancedButton minFmVersionButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.layoutoptions.version.minimum", (String[])new String[0]), true, press -> {
                FMTextInputPopup p = new FMTextInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"helper.creator.layoutoptions.version.minimum.fm", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (this.parent.minimumFM != call) {
                            this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        }
                        this.parent.minimumFM = call;
                    }
                });
                if (this.parent.minimumFM != null) {
                    p.setText(this.parent.minimumFM);
                }
                PopupHandler.displayPopup((Popup)p);
            });
            fmVersionMenu.addContent(minFmVersionButton);
            AdvancedButton maxFmVersionButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.layoutoptions.version.maximum", (String[])new String[0]), true, press -> {
                FMTextInputPopup p = new FMTextInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"helper.creator.layoutoptions.version.maximum.fm", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (this.parent.maximumFM != call) {
                            this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                        }
                        this.parent.maximumFM = call;
                    }
                });
                if (this.parent.maximumFM != null) {
                    p.setText(this.parent.maximumFM);
                }
                PopupHandler.displayPopup((Popup)p);
            });
            fmVersionMenu.addContent(maxFmVersionButton);
            AdvancedButton fmVersionButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.layoutoptions.version.fm", (String[])new String[0]), true, press -> {
                fmVersionMenu.setParentButton((AdvancedButton)press);
                fmVersionMenu.openMenuAt(0, press.field_230691_m_, screenWidth, screenHeight);
            });
            this.addContent(fmVersionButton);
            if (this.isRightclickOpened) {
                this.addSeparator();
            }
            AdvancedButton pasteButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.editor.ui.edit.paste", (String[])new String[0]), press -> this.parent.pasteElements());
            if (this.isRightclickOpened) {
                this.addContent(pasteButton);
            }
            NewElementContextMenu newElementMenu = new NewElementContextMenu(this.parent);
            newElementMenu.setAutoclose(true);
            this.addChild(newElementMenu);
            AdvancedButton newElementButton = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.editor.ui.layoutproperties.newelement", (String[])new String[0]), press -> {
                newElementMenu.setParentButton((AdvancedButton)press);
                newElementMenu.openMenuAt(0, press.field_230691_m_, screenWidth, screenHeight);
            });
            if (this.isRightclickOpened) {
                this.addContent(newElementButton);
            }
            super.openMenuAt(x, y, screenWidth, screenHeight);
        }
    }

    private static class OpenLayoutContextMenu
    extends FMContextMenu {
        private LayoutEditorUI ui;

        public OpenLayoutContextMenu(LayoutEditorUI ui) {
            this.ui = ui;
        }

        @Override
        public void openMenuAt(int x, int y, int screenWidth, int screenHeight) {
            List<PropertiesSet> disabled;
            List<PropertiesSet> enabled;
            this.content.clear();
            String identifier = this.ui.parent.screen.getClass().getName();
            if (this.ui.parent.screen instanceof CustomGuiBase) {
                identifier = ((CustomGuiBase)this.ui.parent.screen).getIdentifier();
            }
            if (!(enabled = MenuCustomizationProperties.getPropertiesWithIdentifier(identifier)).isEmpty()) {
                for (PropertiesSet s : enabled) {
                    List secs = s.getPropertiesOfType("customization-meta");
                    if (secs.isEmpty()) {
                        secs = s.getPropertiesOfType("type-meta");
                    }
                    if (secs.isEmpty()) continue;
                    String name = "<missing name>";
                    PropertiesSection meta = (PropertiesSection)secs.get(0);
                    File f = new File(meta.getEntryValue("path"));
                    if (!f.isFile()) continue;
                    name = Files.getNameWithoutExtension((String)f.getName());
                    int totalactions = s.getProperties().size() - 1;
                    AdvancedButton layoutEntryBtn = new AdvancedButton(0, 0, 0, 0, "\u00a7a" + name, press -> this.ui.displayUnsavedWarning(call -> CustomizationHelper.editLayout(this.ui.parent.screen, f)));
                    layoutEntryBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.buttons.customization.managelayouts.layout.btndesc", (String[])new String[]{Locals.localize((String)"helper.buttons.customization.managelayouts.enabled", (String[])new String[0]), "" + totalactions}), (String)"%n%"));
                    this.addContent(layoutEntryBtn);
                }
            }
            if (!(disabled = MenuCustomizationProperties.getDisabledPropertiesWithIdentifier(identifier)).isEmpty()) {
                for (PropertiesSet s : disabled) {
                    List secs = s.getPropertiesOfType("customization-meta");
                    if (secs.isEmpty()) {
                        secs = s.getPropertiesOfType("type-meta");
                    }
                    if (secs.isEmpty()) continue;
                    String name = "<missing name>";
                    PropertiesSection meta = (PropertiesSection)secs.get(0);
                    File f = new File(meta.getEntryValue("path"));
                    if (!f.isFile()) continue;
                    name = Files.getNameWithoutExtension((String)f.getName());
                    int totalactions = s.getProperties().size() - 1;
                    AdvancedButton layoutEntryBtn = new AdvancedButton(0, 0, 0, 0, "\u00a7c" + name, press -> this.ui.displayUnsavedWarning(call -> CustomizationHelper.editLayout(this.ui.parent.screen, f)));
                    layoutEntryBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.buttons.customization.managelayouts.layout.btndesc", (String[])new String[]{Locals.localize((String)"helper.buttons.customization.managelayouts.disabled", (String[])new String[0]), "" + totalactions}), (String)"%n%"));
                    this.addContent(layoutEntryBtn);
                }
            }
            if (enabled.isEmpty() && disabled.isEmpty()) {
                AdvancedButton emptyBtn = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.empty", (String[])new String[0]), press -> {});
                this.addContent(emptyBtn);
            }
            super.openMenuAt(x, y, screenWidth, screenHeight);
        }
    }
}

